#include <p30fxxxx.h>
#include <ports.h>

/********************************************************************
* Function Name     : ConfigINT0
* Description       : Enables external interrupt on pin INT0.
* Parameters        : config determines the interrupt edge, priority 
*                     and enable/disable information.
* Return Value      : None
********************************************************************/

void ConfigINT0(unsigned int config)
{
    IFS0bits.INT0IF = 0;                       /* clear the interrupt flag */
    IPC0bits.INT0IP = config & 0x07;           /* assign interrupt priority */

    INTCON2bits.INT0EP = (config & 0x10) >> 4; /* assign edge selected */

    IEC0bits.INT0IE = (config & 0x08) >> 3;    /* enable/disable interrupt */
}
/* end of function ConfigINT0 */
